<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\SearchResponse;
use PaypalServerSdkLib\Models\TransactionDetails;

/**
 * Builder for model SearchResponse
 *
 * @see SearchResponse
 */
class SearchResponseBuilder
{
    /**
     * @var SearchResponse
     */
    private $instance;

    private function __construct(SearchResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Search Response Builder object.
     */
    public static function init(): self
    {
        return new self(new SearchResponse());
    }

    /**
     * Sets transaction details field.
     *
     * @param TransactionDetails[]|null $value
     */
    public function transactionDetails(?array $value): self
    {
        $this->instance->setTransactionDetails($value);
        return $this;
    }

    /**
     * Sets account number field.
     *
     * @param string|null $value
     */
    public function accountNumber(?string $value): self
    {
        $this->instance->setAccountNumber($value);
        return $this;
    }

    /**
     * Sets start date field.
     *
     * @param string|null $value
     */
    public function startDate(?string $value): self
    {
        $this->instance->setStartDate($value);
        return $this;
    }

    /**
     * Sets end date field.
     *
     * @param string|null $value
     */
    public function endDate(?string $value): self
    {
        $this->instance->setEndDate($value);
        return $this;
    }

    /**
     * Sets last refreshed datetime field.
     *
     * @param string|null $value
     */
    public function lastRefreshedDatetime(?string $value): self
    {
        $this->instance->setLastRefreshedDatetime($value);
        return $this;
    }

    /**
     * Sets page field.
     *
     * @param int|null $value
     */
    public function page(?int $value): self
    {
        $this->instance->setPage($value);
        return $this;
    }

    /**
     * Sets total items field.
     *
     * @param int|null $value
     */
    public function totalItems(?int $value): self
    {
        $this->instance->setTotalItems($value);
        return $this;
    }

    /**
     * Sets total pages field.
     *
     * @param int|null $value
     */
    public function totalPages(?int $value): self
    {
        $this->instance->setTotalPages($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Search Response object.
     */
    public function build(): SearchResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
